/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.panels.StringInputProcessingClient;
import com.izforge.izpack.panels.UserInputFileFilter;
import com.izforge.izpack.panels.ValidatorContainer;
import com.izforge.izpack.util.Debug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileInputField
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 4673684743657328492L;
    InstallerFrame parentFrame;
    IzPanel parent;
    List<ValidatorContainer> validators;
    JTextField filetxt;
    JButton browseBtn;
    String set;
    int size;
    InstallData data;
    String fileExtension;
    String fileExtensionDescription;
    boolean allowEmpty;
    protected static final int INVALID = 0;
    protected static final int EMPTY = 1;

    public FileInputField(IzPanel izPanel, InstallData installData, boolean bl, String string, int n, List<ValidatorContainer> list) {
        this(izPanel, installData, bl, string, n, list, null, null);
    }

    public FileInputField(IzPanel izPanel, InstallData installData, boolean bl, String string, int n, List<ValidatorContainer> list, String string2, String string3) {
        this.parent = izPanel;
        this.parentFrame = izPanel.getInstallerFrame();
        this.data = installData;
        this.validators = list;
        this.set = string;
        this.size = n;
        this.fileExtension = string2;
        this.fileExtensionDescription = string3;
        this.initialize();
    }

    private void initialize() {
        this.filetxt = new JTextField(this.set, this.size);
        this.filetxt.setCaretPosition(0);
        this.browseBtn = ButtonFactory.createButton(this.data.langpack.getString("UserInputPanel.search.browse"), this.data.buttonsHColor);
        this.browseBtn.addActionListener(this);
        this.add(this.filetxt);
        this.add(this.browseBtn);
    }

    public void setFile(String string) {
        this.filetxt.setText(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.browseBtn) {
            Debug.trace("Show dirchooser");
            String string = ".";
            if (this.filetxt.getText() != null) {
                string = this.filetxt.getText();
            }
            JFileChooser jFileChooser = new JFileChooser(string);
            this.prepareFileChooser(jFileChooser);
            if (jFileChooser.showOpenDialog(this.parentFrame) == 0) {
                String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
                this.filetxt.setText(string2);
                Debug.trace("Setting current file chooser directory to: " + string2);
            }
        }
    }

    protected void prepareFileChooser(JFileChooser jFileChooser) {
        jFileChooser.setFileSelectionMode(0);
        if (this.fileExtension != null && this.fileExtensionDescription != null) {
            UserInputFileFilter userInputFileFilter = new UserInputFileFilter();
            userInputFileFilter.setFileExt(this.fileExtension);
            userInputFileFilter.setFileExtDesc(this.fileExtensionDescription);
            jFileChooser.setFileFilter(userInputFileFilter);
        }
    }

    public File getSelectedFile() {
        File file = null;
        if (this.filetxt.getText() != null) {
            file = new File(this.filetxt.getText());
        }
        return file;
    }

    protected void showMessage(int n) {
        if (n == 0) {
            this.showMessage("file.notfile");
        } else if (n == 1) {
            this.showMessage("file.nofile");
        }
    }

    protected void showMessage(String string) {
        JOptionPane.showMessageDialog(this.parentFrame, this.parentFrame.langpack.getString("UserInputPanel." + string + ".message"), this.parentFrame.langpack.getString("UserInputPanel." + string + ".caption"), 2);
    }

    public boolean validateField() {
        boolean bl = false;
        String string = this.filetxt.getText();
        if (this.allowEmpty && (string == null || string.length() == 0)) {
            bl = true;
        } else if (string != null) {
            Object object;
            if (string.startsWith("~")) {
                object = System.getProperty("user.home");
                string = (String)object + string.substring(1);
            }
            object = new File(string).getAbsoluteFile();
            string = ((File)object).toString();
            this.filetxt.setText(string);
            if (!this._validate((File)object)) {
                bl = false;
                this.showMessage(0);
            } else {
                StringInputProcessingClient stringInputProcessingClient = new StringInputProcessingClient(string, this.validators);
                boolean bl2 = stringInputProcessingClient.validate();
                if (!bl2) {
                    JOptionPane.showMessageDialog(this.parentFrame, stringInputProcessingClient.getValidationMessage(), this.parentFrame.langpack.getString("UserInputPanel.error.caption"), 2);
                }
                bl = bl2;
            }
        } else {
            this.showMessage(1);
        }
        return bl;
    }

    protected boolean _validate(File file) {
        return file.isFile();
    }

    public boolean isAllowEmptyInput() {
        return this.allowEmpty;
    }

    public void setAllowEmptyInput(boolean bl) {
        this.allowEmpty = bl;
    }
}

