/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class RuleTextField
extends JTextField {
    private static final long serialVersionUID = 3976731454594365493L;
    public static final int N = 1;
    public static final int H = 2;
    public static final int A = 3;
    public static final int O = 4;
    public static final int AN = 5;
    private int columns;
    private int editLength;
    private boolean unlimitedEdit;
    private Toolkit toolkit;

    public RuleTextField(int n, int n2, int n3, boolean bl, Toolkit toolkit) {
        super(n + 1);
        this.setColumns(n);
        this.toolkit = toolkit;
        this.editLength = n2;
        this.unlimitedEdit = bl;
        Rule rule = new Rule();
        rule.setRuleType(n3, n2, bl);
        this.setDocument(rule);
    }

    protected Document createDefaultModel() {
        Rule rule = new Rule();
        return rule;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getEditLength() {
        return this.editLength;
    }

    public boolean unlimitedEdit() {
        return this.unlimitedEdit;
    }

    public void setColumns(int n) {
        super.setColumns(n + 1);
        this.columns = n;
    }

    class Rule
    extends PlainDocument {
        private static final long serialVersionUID = 3258134643651063862L;
        private int editLength;
        private int type;
        private boolean unlimitedEdit;

        Rule() {
        }

        public void setRuleType(int n, int n2, boolean bl) {
            this.type = n;
            this.editLength = n2;
            this.unlimitedEdit = bl;
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            int n2 = this.getLength() + string.length();
            if (n2 <= this.editLength || this.unlimitedEdit) {
                boolean bl = false;
                if (this.type == 1) {
                    for (int i = 0; i < string.length(); ++i) {
                        if (Character.isDigit(string.charAt(i))) continue;
                        bl = true;
                    }
                } else if (this.type == 2) {
                    for (int i = 0; i < string.length(); ++i) {
                        char c = Character.toUpperCase(string.charAt(i));
                        if (Character.isDigit(c) || c == 'A' || c == 'B' || c == 'C' || c == 'D' || c == 'E' || c == 'F') continue;
                        bl = true;
                    }
                } else if (this.type == 3) {
                    for (int i = 0; i < string.length(); ++i) {
                        if (Character.isLetter(string.charAt(i))) continue;
                        bl = true;
                    }
                } else if (this.type == 5) {
                    for (int i = 0; i < string.length(); ++i) {
                        if (Character.isLetterOrDigit(string.charAt(i))) continue;
                        bl = true;
                    }
                } else if (this.type != 4) {
                    System.out.println("type = " + this.type);
                }
                if (!bl) {
                    super.insertString(n, string, attributeSet);
                } else {
                    RuleTextField.this.toolkit.beep();
                }
            } else {
                RuleTextField.this.toolkit.beep();
            }
        }
    }
}

