/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAutomation;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.panels.ShortcutData;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.TargetFactory;
import com.izforge.izpack.util.os.Shortcut;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;

public class ShortcutPanelAutomationHelper
implements PanelAutomation {
    public void makeXMLData(AutomatedInstallData automatedInstallData, IXMLElement iXMLElement) {
        Debug.log(this.getClass().getName() + "::entering makeXMLData()");
    }

    public void runAutomated(AutomatedInstallData automatedInstallData, IXMLElement iXMLElement) {
        ShortcutData shortcutData;
        int n;
        Shortcut shortcut;
        Vector<ShortcutData> vector = new Vector<ShortcutData>();
        Vector<ExecutableFile> vector2 = new Vector<ExecutableFile>();
        Vector<String> vector3 = new Vector<String>();
        Debug.log(this.getClass().getName() + " Entered runAutomated()");
        try {
            shortcut = (Shortcut)TargetFactory.getInstance().makeObject("com.izforge.izpack.util.os.Shortcut");
            shortcut.initialize(1, "-");
        }
        catch (Throwable throwable) {
            Debug.log("Could not create shortcut instance");
            throwable.printStackTrace();
            return;
        }
        if (!shortcut.supported()) {
            Debug.log("shortcuts not supported here");
            return;
        }
        if (!OsConstraint.oneMatchesCurrentSystem(iXMLElement)) {
            Debug.log("Shortcuts Not oneMatchesCurrentSystem");
            return;
        }
        vector = new Vector();
        IXMLElement iXMLElement2 = iXMLElement.getFirstChildNamed("programGroup");
        String string = null;
        if (iXMLElement2 != null) {
            string = iXMLElement2.getAttribute("name");
        }
        if (string == null) {
            string = "";
        }
        Vector<IXMLElement> vector4 = iXMLElement.getChildrenNamed("shortcut");
        for (n = 0; n < vector4.size(); ++n) {
            Debug.log(this.getClass().getName() + "runAutomated:shortcutElements " + n);
            shortcutData = new ShortcutData();
            iXMLElement2 = vector4.elementAt(n);
            shortcutData.name = iXMLElement2.getAttribute("name");
            shortcutData.addToGroup = Boolean.valueOf(iXMLElement2.getAttribute("group"));
            if (OsVersion.IS_WINDOWS) {
                shortcutData.type = Integer.valueOf(iXMLElement2.getAttribute("type"));
            } else {
                Debug.log("WARN: On Linux data.type is NOT an int. Ignored.");
            }
            shortcutData.commandLine = iXMLElement2.getAttribute("commandLine");
            shortcutData.description = iXMLElement2.getAttribute("description");
            shortcutData.iconFile = iXMLElement2.getAttribute("icon");
            shortcutData.iconIndex = Integer.valueOf(iXMLElement2.getAttribute("iconIndex"));
            shortcutData.initialState = Integer.valueOf(iXMLElement2.getAttribute("initialState"));
            shortcutData.target = iXMLElement2.getAttribute("target");
            shortcutData.workingDirectory = iXMLElement2.getAttribute("workingDirectory");
            shortcutData.deskTopEntryLinux_Encoding = iXMLElement2.getAttribute("encoding", "");
            shortcutData.deskTopEntryLinux_MimeType = iXMLElement2.getAttribute("mimetype", "");
            shortcutData.deskTopEntryLinux_Terminal = iXMLElement2.getAttribute("terminal", "");
            shortcutData.deskTopEntryLinux_TerminalOptions = iXMLElement2.getAttribute("terminalOptions", "");
            shortcutData.deskTopEntryLinux_Type = iXMLElement2.getAttribute("type", "");
            shortcutData.deskTopEntryLinux_URL = iXMLElement2.getAttribute("url", "");
            shortcutData.deskTopEntryLinux_X_KDE_SubstituteUID = iXMLElement2.getAttribute("KdeSubstUID", "false");
            shortcutData.deskTopEntryLinux_X_KDE_UserName = iXMLElement2.getAttribute("KdeUsername", "root");
            shortcutData.Categories = iXMLElement2.getAttribute("categories", "Application;Development");
            shortcutData.TryExec = iXMLElement2.getAttribute("tryexec", "");
            shortcutData.createForAll = Boolean.valueOf(iXMLElement2.getAttribute("createForAll", "false"));
            shortcutData.userType = Integer.valueOf(iXMLElement2.getAttribute("usertype", Integer.toString(1)));
            vector.add(shortcutData);
        }
        System.out.print("[ Creating shortcuts ");
        for (n = 0; n < vector.size(); ++n) {
            shortcutData = (ShortcutData)vector.elementAt(n);
            try {
                if (shortcutData.subgroup != null) {
                    string = string + shortcutData.subgroup;
                }
                shortcut.setUserType(shortcutData.userType);
                shortcut.setLinkName(shortcutData.name);
                if (OsVersion.IS_WINDOWS) {
                    shortcut.setLinkType(shortcutData.type);
                }
                shortcut.setArguments(shortcutData.commandLine);
                shortcut.setDescription(shortcutData.description);
                shortcut.setIconLocation(shortcutData.iconFile, shortcutData.iconIndex);
                shortcut.setShowCommand(shortcutData.initialState);
                shortcut.setTargetPath(shortcutData.target);
                shortcut.setWorkingDirectory(shortcutData.workingDirectory);
                shortcut.setEncoding(shortcutData.deskTopEntryLinux_Encoding);
                shortcut.setMimetype(shortcutData.deskTopEntryLinux_MimeType);
                shortcut.setTerminal(shortcutData.deskTopEntryLinux_Terminal);
                shortcut.setTerminalOptions(shortcutData.deskTopEntryLinux_TerminalOptions);
                if (!OsVersion.IS_WINDOWS) {
                    shortcut.setType(shortcutData.deskTopEntryLinux_Type);
                }
                shortcut.setKdeSubstUID(shortcutData.deskTopEntryLinux_X_KDE_SubstituteUID);
                shortcut.setURL(shortcutData.deskTopEntryLinux_URL);
                shortcut.setCreateForAll(shortcutData.createForAll);
                if (shortcutData.addToGroup) {
                    shortcut.setProgramGroup(string);
                } else {
                    shortcut.setProgramGroup("");
                }
                try {
                    System.out.print(".");
                    System.out.flush();
                    shortcut.save();
                    String string2 = shortcut.getFileName();
                    vector3.add(0, string2);
                    File file = new File(string2);
                    File file2 = new File(shortcut.getBasePath());
                    Vector<File> vector5 = new Vector<File>();
                    vector2.add(new ExecutableFile(string2, 2, 3, new ArrayList<OsConstraint>(), false));
                    vector3.add(string2);
                    while ((file = file.getParentFile()) != null && !file.equals(file2)) {
                        vector5.add(file);
                    }
                    if (file == null) continue;
                    Enumeration enumeration = vector5.elements();
                    while (enumeration.hasMoreElements()) {
                        vector3.add(0, ((File)enumeration.nextElement()).toString());
                    }
                    continue;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            if (vector2 != null) {
                FileExecutor fileExecutor = new FileExecutor(vector2);
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        System.out.println(" done. ]");
        System.out.print("[ Add shortcuts to uninstaller ");
        UninstallData uninstallData = UninstallData.getInstance();
        for (int i = 0; i < vector3.size(); ++i) {
            uninstallData.addFile((String)vector3.elementAt(i), true);
            System.out.print(".");
            System.out.flush();
        }
        System.out.println(" done. ]");
    }
}

