/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.FlowLayout;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Processor;
import com.izforge.izpack.panels.RuleTextField;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.regexp.RE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleInputField
extends JComponent
implements KeyListener,
FocusListener,
CaretListener,
ProcessingClient {
    private static final long serialVersionUID = 3832616275124958257L;
    public static final int PLAIN_STRING = 1;
    public static final int DISPLAY_FORMAT = 2;
    public static final int SPECIAL_SEPARATOR = 3;
    public static final int ENCRYPTED = 4;
    private static int DEFAULT = 2;
    private Vector<Serializable> items = new Vector();
    private Vector inputFields = new Vector();
    private boolean hasParams = false;
    private Map<String, String> validatorParams;
    private RuleTextField activeField;
    private boolean backstep = false;
    private Toolkit toolkit;
    private String separator;
    private int resultFormat = DEFAULT;
    private InstallData idata = null;
    private Validator validationService;
    private Processor encryptionService;

    @Override
    public boolean hasParams() {
        return this.hasParams;
    }

    public RuleInputField(String string, String string2, String string3, String string4, Map<String, String> map, String string5, int n, Toolkit toolkit, InstallData installData) {
        this(string, string2, string3, string4, string5, n, toolkit, installData);
        this.validatorParams = map;
        this.hasParams = true;
    }

    public RuleInputField(String string, String string2, String string3, String string4, String string5, int n, Toolkit toolkit, InstallData installData) {
        this.toolkit = toolkit;
        this.separator = string3;
        this.resultFormat = n;
        this.idata = installData;
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        this.setLayout(flowLayout);
        try {
            if (string4 != null) {
                this.validationService = (Validator)Class.forName(string4).newInstance();
            }
        }
        catch (Throwable throwable) {
            this.validationService = null;
            Debug.trace(throwable);
        }
        try {
            if (string5 != null) {
                this.encryptionService = (Processor)Class.forName(string5).newInstance();
            }
        }
        catch (Throwable throwable) {
            this.encryptionService = null;
            Debug.trace(throwable);
        }
        this.createItems(string);
        if (string2 != null && string2.length() > 0) {
            this.setFields(string2);
        }
        this.activeField = (RuleTextField)this.inputFields.elementAt(0);
        this.activeField.grabFocus();
    }

    @Override
    public int getNumFields() {
        return this.inputFields.size();
    }

    @Override
    public String getFieldContents(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.inputFields.size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        return ((JTextField)this.inputFields.elementAt(n)).getText();
    }

    @Override
    public Map<String, String> getValidatorParams() {
        return this.validatorParams;
    }

    @Override
    public String getText() {
        StringBuffer stringBuffer;
        block7: {
            int n;
            block9: {
                block8: {
                    block6: {
                        stringBuffer = new StringBuffer();
                        n = this.inputFields.size();
                        if (this.resultFormat != 4) break block6;
                        if (this.encryptionService != null) {
                            stringBuffer.append(this.encryptionService.process(this));
                        } else {
                            this.resultFormat = DEFAULT;
                        }
                        break block7;
                    }
                    if (this.resultFormat != 1) break block8;
                    for (int i = 0; i < this.inputFields.size(); ++i) {
                        stringBuffer.append(((JTextField)this.inputFields.elementAt(i)).getText());
                    }
                    break block7;
                }
                if (this.resultFormat != 2) break block9;
                for (int i = 0; i < this.items.size(); ++i) {
                    Serializable serializable = this.items.elementAt(i);
                    if (serializable instanceof JTextField) {
                        stringBuffer.append(((JTextField)serializable).getText());
                        continue;
                    }
                    stringBuffer.append((String)((Object)serializable));
                }
                break block7;
            }
            if (this.resultFormat != 3) break block7;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(((JTextField)this.inputFields.elementAt(i)).getText());
                if (i >= n - 1) continue;
                stringBuffer.append(this.separator);
            }
        }
        return stringBuffer.toString();
    }

    private void createItems(String string) {
        Serializable serializable;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                FieldSpec fieldSpec = new FieldSpec(string2);
                RuleTextField ruleTextField = new RuleTextField(fieldSpec.getColumns(), fieldSpec.getEditLength(), fieldSpec.getType(), fieldSpec.getUnlimitedEdit(), this.toolkit);
                if (this.items.size() > 0 && (serializable = this.items.lastElement()) instanceof JTextField) {
                    this.items.add((Serializable)((Object)" "));
                }
                this.items.add(ruleTextField);
                this.inputFields.add(ruleTextField);
                ruleTextField.addFocusListener(this);
                ruleTextField.addKeyListener(this);
                ruleTextField.addCaretListener(this);
            }
            catch (Throwable throwable) {
                if (this.items.size() == 0) {
                    this.items.add((Serializable)((Object)string2));
                    continue;
                }
                serializable = this.items.lastElement();
                if (serializable instanceof String) {
                    this.items.setElementAt((Serializable)((Object)(serializable + " " + string2)), this.items.size() - 1);
                    continue;
                }
                this.items.add((Serializable)((Object)string2));
            }
        }
        for (int i = 0; i < this.items.size(); ++i) {
            serializable = this.items.elementAt(i);
            if (serializable instanceof String) {
                this.add(new JLabel((String)((Object)serializable)));
                continue;
            }
            this.add((JTextField)serializable);
        }
    }

    private void setFields(String string) {
        Object object;
        String string2;
        String string3;
        int n;
        String string4;
        String string5;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        boolean bl = false;
        String[] stringArray = null;
        int n2 = 0;
        stringArray = new String[stringTokenizer.countTokens()];
        while (stringTokenizer.hasMoreTokens()) {
            string5 = stringTokenizer.nextToken();
            string4 = string5.substring(0, string5.indexOf(58));
            try {
                n = Integer.parseInt(string4);
                if (n >= this.inputFields.size()) continue;
                string3 = string5.substring(string5.indexOf(58) + 1, string5.length());
                string2 = "";
                if (string3.indexOf(":") > -1) {
                    string2 = string3.substring(string3.indexOf(":") + 1);
                    string3 = string3.substring(0, string3.indexOf(":"));
                }
                if (!"".equals(string2) && !bl) {
                    bl = true;
                }
                object = new VariableSubstitutor(this.idata.getVariables());
                stringArray[n2] = string3 = ((VariableSubstitutor)object).substitute(string3, null);
                ++n2;
                ((JTextField)this.inputFields.elementAt(n)).setText(string3);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (bl) {
            stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                string5 = stringTokenizer.nextToken();
                string4 = string5.substring(0, string5.indexOf(58));
                try {
                    String[] stringArray2;
                    n = Integer.parseInt(string4);
                    if (n >= this.inputFields.size()) continue;
                    string3 = string5.substring(string5.indexOf(58) + 1, string5.length());
                    string2 = "";
                    object = "";
                    if (string3.indexOf(":") > -1) {
                        string2 = string3.substring(string3.indexOf(":") + 1);
                        string3 = string3.substring(0, string3.indexOf(":"));
                    }
                    if (!"".equals(string2)) {
                        stringArray2 = (String[])Class.forName(string2).newInstance();
                        object = stringArray2.process(this);
                    }
                    stringArray2 = new RE("\\*").split((String)object);
                    ((JTextField)this.inputFields.elementAt(n)).setText(stringArray2[n]);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public boolean validateContents() {
        if (this.validationService != null) {
            return this.validationService.validate(this);
        }
        return true;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n;
        int n2;
        if (keyEvent.getKeyCode() == 8 && (n2 = this.activeField.getCaretPosition()) == 0 && (n = this.inputFields.indexOf(this.activeField)) > 0) {
            this.backstep = true;
            this.activeField = (RuleTextField)this.inputFields.elementAt(--n);
            this.activeField.grabFocus();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.activeField = (RuleTextField)focusEvent.getSource();
        if (this.backstep) {
            this.activeField.setCaretPosition(this.activeField.getText().length());
            this.backstep = false;
        } else {
            this.activeField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        if (this.activeField != null) {
            String string = this.activeField.getText();
            int n = this.activeField.getEditLength();
            int n2 = this.activeField.getCaretPosition();
            int n3 = this.activeField.getSelectionEnd() - this.activeField.getSelectionStart();
            if (!(this.inputFields.lastElement().equals(this.activeField) || this.activeField.unlimitedEdit() || string.length() != n || n3 != 0 || n2 != n || this.backstep)) {
                this.activeField.transferFocus();
            }
        }
    }

    private static class FieldSpec {
        private int MIN_TOKENS = 2;
        private int MAX_TOKENS = 3;
        private int type;
        private int columns;
        private int editLength;
        private boolean unlimitedEdit = false;

        public FieldSpec(String string) throws Exception {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            if (stringTokenizer.countTokens() >= this.MIN_TOKENS && stringTokenizer.countTokens() <= this.MAX_TOKENS) {
                String string2 = stringTokenizer.nextToken().toUpperCase();
                if ("N".equals(string2)) {
                    this.type = 1;
                } else if ("H".equals(string2)) {
                    this.type = 2;
                } else if ("A".equals(string2)) {
                    this.type = 3;
                } else if ("O".equals(string2)) {
                    this.type = 4;
                } else if ("AN".equals(string2)) {
                    this.type = 5;
                } else {
                    throw new Exception();
                }
                try {
                    string2 = stringTokenizer.nextToken();
                    this.columns = Integer.parseInt(string2);
                }
                catch (Throwable throwable) {
                    throw new Exception();
                }
                try {
                    string2 = stringTokenizer.nextToken().toUpperCase();
                    this.editLength = Integer.parseInt(string2);
                }
                catch (Throwable throwable) {
                    if ("U".equals(string2)) {
                        this.unlimitedEdit = true;
                    }
                    throw new Exception();
                }
            } else {
                throw new Exception();
            }
        }

        public int getColumns() {
            return this.columns;
        }

        public int getEditLength() {
            return this.editLength;
        }

        public int getType() {
            return this.type;
        }

        public boolean getUnlimitedEdit() {
            return this.unlimitedEdit;
        }
    }
}

